# get details from the command line
$sDetails = $args[0]

# smtp server
$emailSmtpServer = "smtp.MYSERVER.com"
$emailSmtpServerPort = "587"

# sender and recipient info
$emailFrom = "me@yourdomain.com"
$emailTo = "you@yourdomain.com,archer.logs@bitsight.com"

# message
$cwd = Get-Location
$emailMessage = New-Object System.Net.Mail.MailMessage( $emailFrom , $emailTo )
$emailMessage.Subject = "BitSight Daily Script Error"
$emailMessage.IsBodyHtml = $true
$emailMessage.Body = "<h2>Error Running BitSight Daily Script</h2>"
$emailMessage.Body += "<b>Details from Script:</b><br>" + $sDetails
$emailMessage.Body += "<br><br>Next Steps: Review logs for details"
$emailMessage.Body += "<br>Log Location: $cwd\\logs"

$attachmentPath = "$cwd\\logs\\100-BitSightTPPSearch.log"
$attach = New-Object System.Net.Mail.Attachment($attachmentPath) 
$emailMessage.Attachments.Add($attach)

$attachmentPath = "$cwd\\logs\\110-BitSightGetHeadlineRatingsNewLicense.log"
$attach = new-object Net.Mail.Attachment($attachmentPath) 
$emailMessage.Attachments.Add($attach)

$attachmentPath = "$cwd\\logs\\120-ChangeSubscriptions.log"
$attach = new-object Net.Mail.Attachment($attachmentPath) 
$emailMessage.Attachments.Add($attach)

$attachmentPath = "$cwd\\logs\\130-BitSightGetBAAVectors.log"
$attach = new-object Net.Mail.Attachment($attachmentPath) 
$emailMessage.Attachments.Add($attach)


# client 
$SMTPClient = New-Object System.Net.Mail.SmtpClient( $emailSmtpServer , $emailSmtpServerPort )

###UNCOMMENT if your email server requires SSL
$SMTPClient.EnableSsl = $True

###UNCOMMENT and set data if your email server requires credentials
#$emailSmtpUser = "emailUser"

#Shouldn't need this since I was able to use the secure pass in PowerShell using this: Read-Host "Enter Password" -AsSecureString | ConvertFrom-SecureString
#$emailSmtpPass = 'emailPassword'

#The line below uses the secure string and that is passed in.
#$emailSmtpPass = "SECURE_STRING" | ConvertTo-SecureString

$SMTPClient.Credentials = New-Object System.Net.NetworkCredential( $emailSmtpUser , $emailSmtpPass );


# send the email
$SMTPClient.Send( $emailMessage )
